<?php
require_once("config.inc");
require_once("util.inc");
require_once("filter.inc");
require_once("interfaces.inc");

function getOrigin($rule) {
  $origins = [200000 => 'floating', 300000 => 'group', 400000 => 'interface'];
  $origin = $origins[$rule['#priority']];
  if  (!isset($origin)) {
    $origin = 'internal';
  }
  return $origin;
}

$rules = filter_core_get_initialized_plugin_system();
filter_core_bootstrap($rules);
plugins_firewall($rules);
filter_core_rules_user($rules);

$xml = new SimpleXMLElement('<fw></fw>');
$filterNode = $xml->addChild('filter');
$userRulesNode = $xml->addChild('userRules');
foreach ($rules->iterateFilterRules() as $rule):
  $rawRule = $rule->getRawRule();

  $ruleNode = $filterNode->addChild('rule');

  # This is user created node - generate uuid->{label,seq} mapping and later use
  # to fix missing rule labels in config.xml
  if (!empty($rawRule['@attributes']) && !empty($rawRule['@attributes']['uuid'])) {
      $userRule = $userRulesNode->addChild('rule');
      $userRule->addChild('uuid', $rawRule['@attributes']['uuid']);
      $userRule->addChild('label', $rule->getLabel());
      $userRule->addChild('seq', $rawRule['seq']);
  } else {
    $ruleNode->addChild('label', $rule->getLabel());
    $ruleNode->addChild('origin', getOrigin($rawRule));

    $ruleNode->addChild('type', $rawRule['type']);
    $rawRule['log'] && $ruleNode->addChild('log', $rawRule['log']);
    $ruleNode->addChild('quick', array_key_exists('quick', $rawRule) && !$rawRule['quick'] ? '0' : '1');
    $rawRule['direction'] && $ruleNode->addChild('direction', $rawRule['direction']);
    $rawRule['ipprotocol'] && $ruleNode->addChild('ipprotocol', $rawRule['ipprotocol']);
    $rawRule['protocol'] && $ruleNode->addChild('protocol', $rawRule['protocol']);
    !$rule->isEnabled() && $ruleNode->addChild('disabled', '1');
    $rawRule['allowopts'] && $ruleNode->addChild('allowopts', $rawRule['allowopts']);
    $rawRule['statetype'] && $ruleNode->addChild('statetype', $rawRule['statetype']);
    $rawRule['disablereplyto'] && $ruleNode->addChild('disablereplyto', $rawRule['disablereplyto']);

    $rule->getInterface() && $ruleNode->addChild('interface', $rule->getInterface());
    $ruleNode->addChild('descr', $rule->getDescr());

    $gateway = isset($rawRule['gateway']) ? $rawRule['gateway'] : "*";
    $ruleNode->addChild('gateway', $gateway);

    $sourceNode = $ruleNode->addChild('source');

    $sourceNot = isset($rawRule['source']['not']);
    $sourceNot && $sourceNode->addChild('not', '1');

    $sourceAddress = isset($rawRule['from']) ? $rawRule['from']
      : (isset($rawRule['source']['address']) ? $rawRule['source']['address'] : '*');
    $sourceNode->addChild('address', htmlspecialchars($sourceAddress));

    $sourceAny = isset($rawRule['source']['any']);
    $sourceAny && $sourceNode->addChild('any', $rawRule['source']['any']);

    $sourceNetwork = isset($rawRule['source']['network']);
    $sourceNetwork && $sourceNode->addChild('network', $rawRule['source']['network']);

    $sourcePort = isset($rawRule['from_port']) ? $rawRule['from_port']
      : (isset($rawRule['source']['port']) ? $rawRule['source']['port'] : '*');
    $sourceNode->addChild('port', $sourcePort);

    $destNode = $ruleNode->addChild('destination');

    $destNot = isset($rawRule['destination']['not']);
    $destNot && $destNode->addChild('not', '1');

    $destAddress = isset($rawRule['to']) ? $rawRule['to']
      : (isset($rawRule['destination']['address']) ? $rawRule['destination']['address'] : '*');

    $destAddress && $destNode->addChild('address', htmlspecialchars($destAddress));

    $destAny = isset($rawRule['destination']['any']);
    $destAny && $destNode->addChild('any', $rawRule['destination']['any']);

    $destNetwork = isset($rawRule['destination']['network']);
    $destNetwork && $destNode->addChild('network', $rawRule['destination']['network']);

    $destPort = isset($rawRule['to_port']) ? $rawRule['to_port']
      : (isset($rawRule['destination']['port']) ? $rawRule['destination']['port'] : '*');
    $destNode->addChild('port', $destPort);
  }
endforeach;

$gateways = new \OPNsense\Routing\Gateways(legacy_interfaces_details());
$gatewaysNode = $xml->addChild('gateways');
foreach ($gateways->gatewaysIndexedByName(true, true, true) as $gateway):
  $gatewayNode = $gatewaysNode->addChild('gateway_item');
  $gatewayNode->addChild('name', $gateway['name']);
  $gatewayNode->addChild('descr', $gateway['descr']);
  $gatewayNode->addChild('interface', $gateway['interface']);
  $gatewayNode->addChild('gateway', $gateway['gateway']);
  $gatewayNode->addChild('ipprotocol', $gateway['ipprotocol']);
endforeach;

$outfile = fopen("/tmp/rules_export.xml", "w") or die("Can't open file to write");
fwrite($outfile, $xml->asXML());
fclose($outfile);
?>