/*
* Based on pfSense (https://www.pfsense.org)
* Copyright (c) 2004-2013 BSD Perimeter
* Copyright (c) 2013-2016 Electric Sheep Fencing
* Copyright (c) 2014-2025 Rubicon Communications, LLC (Netgate)
* All rights reserved.
*
* originally based on m0n0wall (http://m0n0.ch/wall)
* Copyright (c) 2003-2004 Manuel Kasper <mk@neon1.net>.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

<?php
require_once("config.inc");
require_once("util.inc");
require_once("filter.inc");

$xml = new SimpleXMLElement('<fw></fw>');
$filterNode = $xml->addChild('filter');

$interfaces = get_configured_interface_list();
foreach ($interfaces as $if):
  $showAntilockout = false;
  $showPrivate = false;
  $showBlockbogons = false;

  if (function_exists('config_path_enabled')) {
    if (!config_path_enabled('system/webgui', 'noantilockout') &&
      (((count(config_get_path('interfaces', [])) > 1) && ($if == 'lan')) ||
        ((count(config_get_path('interfaces', [])) == 1) && ($if == 'wan')))) {
      $showAntilockout = true;
    }

    if (config_path_enabled("interfaces/{$if}", "blockpriv")) {
      $showPrivate = true;
    }

    if (config_path_enabled("interfaces/{$if}", "blockbogons")) {
      $showBlockbogons = true;
    }
  } else {
    global $config;
    if (!isset($config['system']['webgui']['noantilockout']) &&
      (((count($config['interfaces']) > 1) && ($if == 'lan')) ||
        ((count($config['interfaces']) == 1) && ($if == 'wan')))) {
      $showAntilockout = true;
    }
    if (isset($config['interfaces'][$if]['blockpriv'])) {
      $showPrivate = true;
    }
    if (isset($config['interfaces'][$if]['blockbogons'])) {
      -$showBlockbogons = true;
    }
  }

  if ($showAntilockout) {
    $ruleNode = $filterNode->addChild('rule');
    $ruleNode->addChild('tracker', '10000-10999');
    $ruleNode->addChild('origin', 'internal');
    $ruleNode->addChild('type', 'pass');
    $ruleNode->addChild('interface', $if);
    $ruleNode->addChild('ipprotocol', 'none');
    $sourceNode = $ruleNode->addChild('source');
    $sourceNode->addChild('address', '*');
    $sourceNode->addChild('port', '*');
    $destNode = $ruleNode->addChild('destination');
    $destNode->addChild('network', $if . 'ip');
    $destNode->addChild('port', implode(' ', filter_get_antilockout_ports(true)));
    $ruleNode->addChild('descr', 'Anti-Lockout Rule');
  }
  if ($showPrivate) {
    $ruleNode = $filterNode->addChild('rule');
    $ruleNode->addChild('tracker', '12000-12999');
    $ruleNode->addChild('origin', 'internal');
    $ruleNode->addChild('type', 'block');
    $ruleNode->addChild('interface', $if);
    $ruleNode->addChild('ipprotocol', 'none');
    $sourceNode = $ruleNode->addChild('source');
    $sourceNode->addChild('address', 'RFC 1918 networks');
    $sourceNode->addChild('port', '*');
    $destNode = $ruleNode->addChild('destination');
    $destNode->addChild('address', '*');
    $destNode->addChild('port', '*');
    $ruleNode->addChild('descr', 'Block private networks');
  }
  if ($showBlockbogons) {
    $ruleNode = $filterNode->addChild('rule');
    $ruleNode->addChild('tracker', '11000-11999');
    $ruleNode->addChild('origin', 'internal');
    $ruleNode->addChild('type', 'block');
    $ruleNode->addChild('interface', $if);
    $ruleNode->addChild('ipprotocol', 'none');
    $sourceNode = $ruleNode->addChild('source');
    $sourceNode->addChild('address', 'Reserved, Not assigned by IANA');
    $sourceNode->addChild('port', '*');
    $destNode = $ruleNode->addChild('destination');
    $destNode->addChild('address', '*');
    $destNode->addChild('port', '*');
    $ruleNode->addChild('descr', 'Block bogon networks');
  }
endforeach;

$gateways = return_gateways_array();
$gatewaysNode = $xml->addChild('gateways');
foreach ($gateways as $gateway):
  $gatewayNode = $gatewaysNode->addChild('gateway_item');
  $gatewayNode->addChild('name', $gateway['name']);
  $gatewayNode->addChild('descr', $gateway['descr']);
  $gatewayNode->addChild('interface', $gateway['interface']);
  $gatewayNode->addChild('gateway', $gateway['gateway']);
  $gatewayNode->addChild('ipprotocol', $gateway['ipprotocol']);
endforeach;

$outfile = fopen("/tmp/rules_export.xml", "w") or die("Can't open file to write");
fwrite($outfile, $xml->asXML());
fclose($outfile);
?>
