<?php

/*
 * Copyright (C) 2016 Deciso B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

require_once("config.inc");
require_once("util.inc");
require_once("XMLRPC_Client.inc");

function xmlrpc_exec($method, $params = [], $debug = false)
{
  global $config;
  $synchronizeto = null;
  $hasync = $config['hasync'];
  if (is_ipaddrv6($hasync['synchronizetoip'])) {
    $hasync['synchronizetoip'] = "[{$hasync['synchronizetoip']}]";
  }

  if (!empty($hasync['synchronizetoip'])) {
    // determine target url
    if (substr($hasync['synchronizetoip'],0, 4) == 'http') {
      // URL provided
      if (substr($hasync['synchronizetoip'], strlen($hasync['synchronizetoip'])-1, 1) == '/') {
        $synchronizeto = $hasync['synchronizetoip']."xmlrpc.php";
      } else {
        $synchronizeto = $hasync['synchronizetoip']."/xmlrpc.php";
      }
    } elseif (!empty($config['system']['webgui']['protocol'])) {
      // no url provided, assume the backup is using the same settings as our box.
      $port = $config['system']['webgui']['port'];
      if (!empty($port)) {
        $synchronizeto =  $config['system']['webgui']['protocol'] . '://'.$hasync['synchronizetoip'].':'.$port."/xmlrpc.php";
      } else {
        $synchronizeto =  $config['system']['webgui']['protocol'] . '://'.$hasync['synchronizetoip']."/xmlrpc.php" ;
      }
    }

    $username = empty($hasync['username']) ? "root" : $hasync['username'];
    $client = new SimpleXMLRPC_Client($synchronizeto,240);
    $client->debug=$debug;
    $client->setCredentials($username, $hasync['password']);
    if ($client->query($method, $params)) {
      return $client->getResponse();
    }
  }
  return false;
}

function get_xmlrpc_services()
{
  return xmlrpc_exec('opnsense.list_services');
}

$services = get_xmlrpc_services();
$result = array();
foreach($services as $service) {
  $result[] = ["name" => $service["name"], "description" => $service["description"], "status" => $service["status"]];
}
echo(json_encode(array("services" => $result)));
?>
